import { useTheme } from '../context/ThemeContext';

export default function Layout({
  children,
  headerContent,
  footerContent,
}: {
  children: React.ReactNode;
  headerContent?: React.ReactNode;
  footerContent?: React.ReactNode;
}) {
  const { theme } = useTheme();

  return (
    <div className={`min-h-screen ${theme.background}`}>
      <header className={`${theme.header} p-4`}>{headerContent || "Customizable Header"}</header>
      <main className="flex-grow">{children}</main>
      <footer className={`${theme.footer} p-4 text-center`}>{footerContent || "Customizable Footer"}</footer>
    </div>
  );
}